import React from 'react'
import { useContext } from 'react'
import { AppContext } from '../context/AppContext'
import { useState } from 'react'
import axios from 'axios'
import { useEffect } from 'react'

const SupplierTransaction = () => {

    const { backendUrl } = useContext(AppContext)
    const [supplierTransaction, setSupplierTransaction] = useState([])

    const getSupplierTransaction = async () => {
        try {
            const { data } = await axios.get(backendUrl + '/api/purchase/get-purchase')
            if (data.success) {
                console.log("data is " , data)
                setSupplierTransaction(data.purchase)

            }

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(()=>{
        getSupplierTransaction()
    },[])

    const toPersianDate = (date) =>
     new Date(date).toLocaleDateString("fa-IR");

    return (
        <div className='py-8 px-16 h-[90vh] overflow-y-scroll'>
            {supplierTransaction.map((p, index) => (
                <div key={index} className="mb-16 border border-gray-500 py-2 px-4 rounded border-t-white border-l-white">

                    <ul key={index} className="grid grid-cols-2 gap-2 w-sm mb-8">
                        <li>نام تمویل کننده:</li>
                        <li>{p.supplierName}</li>

                        <li>تعداد اقلام:</li>
                        <li>{p.items.length}</li>

                        <li>مجموع:</li>
                        <li>{p.totalAmount}</li>

                        <li>پرداخت:</li>
                        <li>{p.paidAmount}</li>

                        <li>باقی:</li>
                        <li>{p.totalAmount - p.paidAmount}</li>

                        <li>بیل نمبر:</li>
                        <li>{p.bellNumber}</li>

                        <li>واحد پولی:</li>
                        <li>{p.currency}</li>

                        <li>تاریخ:</li>
                        <li>{toPersianDate(p.date)}</li>
                    </ul>

                    <ul className="grid grid-cols-9 font-bold mt-4">
                        <li>#</li>
                        <li>نام جنس</li>
                        <li>نوعیت</li>
                        <li>گرام</li>
                        <li>عیار</li>
                        <li>تعداد</li>
                        <li>ثبت شده</li>
                        <li>باقی</li>
                        <li>قیمت</li>
                    </ul>

                    {p.items.map((item, i) => (
                            <ul key={item._id} className="grid grid-cols-9 border-t py-1 text-gray-700">
                                <li>{i + 1}</li>
                                <li>{item.name}</li>
                                <li>{item.type}</li>
                                <li>{item.gram}</li>
                                <li>{item.karat}</li>
                                <li>{item.quantity}</li>
                                <li>{item.registeredQty}</li>
                                <li>{item.remainingQty}</li>
                                <li>{item.price}</li>
                            </ul>
                        ))}
                </div>
            ))}

        </div>
    )
}

export default SupplierTransaction
