import React, { useContext, useEffect, useState } from 'react'
import { AppContext } from '../../context/AppContext'
import { toast } from 'react-toastify'
import axios from 'axios'

const DailyExpense = () => {

    const { backendUrl } = useContext(AppContext)
    const [expense, setExpense] = useState([])

    const getDaily = async () => {
        try {
            const { data } = await axios.get(backendUrl + '/api/expense/daily')
            if (!data.success) {
                return toast.error(data.message)
            }
            if (data.success) {
                console.log(data)
                setExpense(data.daily)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(() => {
        getDaily()
    }, [])

    const toPersianDate = (date) =>
        new Date(date).toLocaleDateString("fa-IR");

    return (
        <div className='py-12 px-16'>
            <ul className='grid grid-cols-5 bg-sky-700 text-white text-center py-1'>
                <li>نوعیت</li>
                <li>جزئیات</li>
                <li>قیمت</li>
                <li>واحد</li>
                <li>تاریخ</li>
            </ul>
            {expense && expense.map((item , index)=>(
                <ul className='grid grid-cols-5 bg-gray-200 text-center py-1'>
                    <li className=''>{item.type}</li>
                    <li className=''>{item.detail}</li>
                    <li className=''>{item.price}</li>
                    <li className=''>{item.currency}</li>
                    <li className=''>{toPersianDate(item.date)}</li>
                </ul>
            ))}
        </div>
    )
}

export default DailyExpense
