import React from 'react'
import { useContext } from 'react'
import { AppContext } from '../../context/AppContext'
import { useState } from 'react'
import { useEffect } from 'react'
import { toast } from 'react-toastify'
import axios from 'axios'

const DailyTrade = () => {

    const { backendUrl } = useContext(AppContext)
    const [daily, setDaily] = useState([])

    const handleDailyTrade = async (req, res) => {
        try {
            const { data } = await axios.get(backendUrl + '/api/trade/daily')
            if (data.success) {
                console.log(data)
                setDaily(data.daily)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(()=>{
        handleDailyTrade()
    },[])

    return (
        <div className='py-8 px-16'>
            <ul className='bg-sky-700 text-white grid grid-cols-[1fr_3fr_3fr_3fr_3fr_3fr] text-center py-1 '>
                <li>#</li>
                <li>نام معامله دار</li>
                <li>مبلغ</li>
                <li>نوعیت</li>
                <li>جزئیات</li>
                <li>واحد</li>
            </ul>
            {daily && daily.map((item , index)=>(
                <ul key={item._id} className=' bg-gray-200 grid grid-cols-[1fr_3fr_3fr_3fr_3fr_3fr] text-center py-1 '>
                    <li>{index +1}</li>
                    <li>{item.traderName}</li>
                    <li>{item.amount}</li>
                    <li>{item.currency}</li>
                    <li>{item.type}</li>
                    <li>{item.detail}</li>
                </ul>
            ))}
        </div>
    )
}

export default DailyTrade
