import React, { useContext, useState } from 'react'
import DatePicker from "react-multi-date-picker";
import persian from "react-date-object/calendars/persian";
import persian_fa from "react-date-object/locales/persian_fa";
import { assets } from '../../assets/assets';
import axios from 'axios';
import { AppContext } from '../../context/AppContext';
import { toast } from 'react-toastify';
import { useNavigate } from 'react-router-dom';

const AddFragment = () => {

    const { backendUrl } = useContext(AppContext)
    const [date, setDate] = useState(null)
    const [gram, setGram] = useState("")
    const [amount, setAmount] = useState("")
    const [detail, setDetail] = useState("")
    const [isToggle, setIsToggle] = useState("")

    const handleAdd = async (e) => {
        e.preventDefault()
        try {
            const { data } = await axios.post(backendUrl + '/api/fragment/add', { gram:parseFloat(gram), amount:(amount), detail, date })
            if (data.success) {
                toast.success(data.message)
                setAmount('')
                setGram('')
                setDetail('')
            }
            if(!data.success){
                return toast.error(data.message)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const convertToEnglish = (str) => {
    const map = {
      "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
      "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
      "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
      "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
    };
    return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
  };

  const navigate = useNavigate()

    return (
        <div className='py-8 px-16'>
            <div className='relative'>  
                <img src={assets.drop_down_icon} onClick={() => setIsToggle(!isToggle)} className='w-6 cursor-pointer' alt="" />
                <div className={` flex flex-col gap-4 bg-sky-700 absolute text-white p-4 rounded-xs right-4 top-8 ${isToggle ? "block" : "hidden"} `}>
                    <p onClick={()=>navigate('/fragment')} className='cursor-pointer'>شکسته موجود</p>
                    <p onClick={()=>navigate('/fragment-report')} className='cursor-pointer'>ثبت گزارش شکسته</p>
                    <p onClick={()=>navigate('/show-fragment-report')} className='cursor-pointer'>نمایش گزارش شکسته</p>
                </div>
            </div>
            <div>
                <h1 className='text-xl text-center mb-4'>ثبت شکسته</h1>
                <div className='flex flex-col items-center'>

                    <form action="" className='flex flex-wrap w-md gap-4 justify-center'>
                        <div>
                            <p>گرام</p>
                            <input onChange={(e) => setGram(convertToEnglish(e.target.value))} value={gram} className='border border-gray-500 py-1 w-72 rounded-xs' inputMode='numeric' type="text" />
                        </div>

                        <div>
                            <p>مبلغ</p>
                            <input onChange={(e) => setAmount(convertToEnglish(e.target.value))} value={amount} className='border border-gray-500 py-1 w-72 rounded-xs' inputMode='numeric' type="text" />
                        </div>

                        <div>
                            <p>جزئیات</p>
                            <textarea onChange={(e) => setDetail(e.target.value)} value={detail} className='border border-gray-500 py-1 w-72 rounded-xs' type="text" />
                        </div>

                        <div>
                            <p>تاریخ</p>
                            <DatePicker
                                value={date}
                                onChange={(value) => setDate(value.toDate())}
                                calendar={persian}
                                locale={persian_fa}
                                format="YYYY/MM/DD"
                                inputClass="border border-gray-500 rounded h-8 w-72 px-2"
                            />
                        </div>
                        <button onClick={(e)=>handleAdd(e)} className='bg-green-600 text-center w-72 py-1 rounded-xs text-white cursor-pointer'>ذخیره</button>
                    </form>

                </div>
            </div>
        </div>
    )
}

export default AddFragment
