import axios from 'axios'
import React from 'react'
import { useContext } from 'react'
import { AppContext } from '../../context/AppContext'
import { useState } from 'react'
import { useEffect } from 'react'
import Barcode from 'react-barcode'

const ExistFragment = () => {

    const { backendUrl } = useContext(AppContext)
    const [dailyFragment, setDailyFragment] = useState()

    const getDailyFragment = async () => {
        try {
            const { data } = await axios.get(backendUrl + '/api/fragment/daily')
            if (data.success) {
                console.log(data)
                setDailyFragment(data.daily)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(()=>{
        getDailyFragment()
    },[])

    return (
        <div className='px-16 py-12'>
            <div>
                <ul className='grid grid-cols-[1fr_2fr_2fr_2fr_2fr_2fr_4fr_4fr] bg-sky-700 text-white text-center'>
                    <li>#</li>
                    <li>نام جنس</li>
                    <li>نوعیت جنس</li>
                    <li>وزن</li>
                    <li>عیار</li>
                    <li>تاریخ</li>
                    <li>عکس</li>
                    <li>بارکود</li>
                </ul>

                {dailyFragment && dailyFragment.map((item , index)=>(
                    <ul className='grid grid-cols-[1fr_2fr_2fr_2fr_2fr_2fr_4fr_4fr] text-center'>
                        <li>{index+1}</li>
                        <li>{item.productName}</li>
                        <li>{item.type}</li>
                        <li>{item.gram}</li>
                        <li>{item.karat}</li>
                        <li>{item.purchasePriceToAfn}</li>
                        <li><img className='w-40' src={`http://localhost:3000/${item.image}`} alt=""  /></li>
                        <li> <Barcode value={item.barcode} format="CODE128" width={0.8} height={50} displayValue fontSize={16} margin={2} /></li>
                    </ul>
                ))}
            </div>
        </div>
    )
}

export default ExistFragment
