import React from 'react'
import { useContext } from 'react'
import { AppContext } from '../../context/AppContext'
import { useState } from 'react'
import { useEffect } from 'react'
import { toast } from 'react-toastify'
import axios from 'axios'
import { assets } from '../../assets/assets'
import DatePicker from "react-multi-date-picker";
import persian from "react-date-object/calendars/persian";
import persian_fa from "react-date-object/locales/persian_fa";


const ExistFragmentMain = () => {
    const { backendUrl } = useContext(AppContext)
    const [notCompleted, setNotCompleted] = useState([])
    const [show, setShow] = useState(false)
    const [gram, setGram] = useState("")
    const [toPasa, setToPasa] = useState("")
    const [detail, setDetail] = useState("")
    const [date, setDate] = useState("")
    const [total , setTotal] = useState([])
    const [isToggle , setIsToggle] = useState(false)

    const handleDelete = async(fragmentId)=>{
        try {
            const {data} = await axios.delete(backendUrl+`/api/fragment/delete` , {params:{id:fragmentId}})
            if(data.success){
                toast.success(data.message)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const getTotal = async(req , res)=>{
        try {
            const {data}= await axios.get(backendUrl+'/api/fragment/total')
            if(data.success){
                console.log(data)
                setTotal(data.total)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const getNotCompleted = async (req, res) => {
        try {
            const { data } = await axios.get(backendUrl + '/api/fragment/notCompleted')
            if (data.success) {
                console.log(data)
                setNotCompleted(data.notCompleted)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(() => {
        getNotCompleted()
        getTotal()
    }, [])

    const convertToEnglish = (str) => {
        const map = {
            "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
            "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
            "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
            "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
        };
        return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
    };


    const toPersianDate = (date) =>
        new Date(date).toLocaleDateString("fa-IR");

    return (
        <div className='px-16 py-12'>
            <div className='flex justify-end relative'>
                <img src={assets.drop_down_icon} onClick={()=>setIsToggle(!isToggle)} className='w-8 cursor-pointer' alt="" />
                <div className={`absolute left-4 top-8 bg-white p-4 rounded-xs ${isToggle ? "block" : "hidden"}`}>
                    <div>
                        <ul className='grid grid-cols-2 gap-4'>
                            <li>مجموع گرام</li>
                            <li>مجموع پول</li>
                        </ul>
                        {total && total.map((item , index)=>(
                            <ul className='grid grid-cols-2 gap-4'>
                                <li>{item.gram}</li>
                                <li>{item.amount}</li>
                            </ul>
                        ))}
                    </div>
                </div>
            </div>
            <div>
                <ul className='grid grid-cols-[1fr_2fr_2fr_4fr_2fr_1fr] text-center bg-sky-700 text-white py-1'>
                    <li>#</li>
                    <li>گرام</li>
                    <li>قیمت</li>
                    <li>جزئیات</li>
                    <li>تاریخ</li>
                    <li>پرداخت</li>
                </ul>
                {notCompleted && notCompleted.map((item, index) => (
                    <ul key={item._id} className='grid grid-cols-[1fr_2fr_2fr_4fr_2fr_1fr] text-center bg-gray-200 py-1'>
                        <li>{index + 1}</li>
                        <li>{item.gram}</li>
                        <li>{item.amount}</li>
                        <li>{item.detail}</li>
                        <li>{toPersianDate(item.createdAt)}</li>
                        <li className='flex justify-center items-center'><img src={assets.delete_icon} onClick={()=>handleDelete(item._id)}  className='w-6 h-6 cursor-pointer' alt="" /></li>
                    </ul>
                ))}
            </div>

            <div className={`fixed inset-0 bg-black/50 flex justify-center items-center ${show ? 'block' : 'hidden'}`}>
                <div className='bg-white px-8 pt-12 pb-2 rounded w-[80%] h-[70%] overflow-y-auto relative'>
                    <img src={assets.cancel_icon} onClick={() => setShow(false)} className='w-6 cursor-pointer absolute top-4 right-4' alt="" />
                    <h1 className='mb-4 font-bold text-lg text-center'>تبدیل به پاسه</h1>
                    <div className='lg:px-40 grid grid-cols-2'>


                        <div className='px-4 py-2'>
                            <p>گرام</p>
                            <input onChange={(e => setGram(e.target.value))} value={gram} className='border border-gray-500/60 rounded-xs w-full px-2 py-1' placeholder='گرام' type="text" inputMode='numeric' />
                        </div>

                        <div className='px-4 py-2'>
                            <p>معادل به پاسه</p>
                            <input onChange={(e) => setToPasa(e.target.value)} value={toPasa} className='border border-gray-500/60 rounded-xs w-full px-2 py-1' placeholder='معادل به پاسه' type="text" inputMode='numeric' />
                        </div>

                        <div className='px-4 py-2'>
                            <p>توضیحات</p>
                            <textarea onChange={(e) => setDetail(e.target.value)} value={detail} className='border border-gray-500/60 rounded-xs w-full px-2 py-1' placeholder='جزئیات' type="text" />
                        </div>

                        <div className='px-4 py-2'>
                            <p>تاریخ</p>
                            <DatePicker
                                value={date}
                                onChange={(value) => setDate(value.toDate())}
                                calendar={persian}
                                locale={persian_fa}
                                format="YYYY/MM/DD"
                                inputClass="border border-gray-500/60 rounded-xs w-full px-2 py-1"
                                placeholder=' تاریخ'
                            />
                        </div>

                    </div>
                    <div className='flex justify-center mt-4 '>
                        <button className='bg-green-600 text-white mx-auto w-60 rounded-xs py-1 cursor-pointer '>ثبت</button>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default ExistFragmentMain
