import React, { useContext, useState } from 'react'
import { AppContext } from '../../context/AppContext'
import WareHouse from '../WareHouse'
import axios from 'axios'
import { toast } from 'react-toastify'

const FragmentReport = () => {

    const { backendUrl } = useContext(AppContext)
    const [totalGram, setTotalGram] = useState("")
    const [totalAmount, setTotalAmount] = useState("")
    const [toWareHouse, setToWareHouse] = useState("")
    const [toPasa, setToPasa] = useState("")
    const [detail, setDetail] = useState("")
    const [date, setDate] = useState(null)

    const handleAdd = async () => {
        try {
            const { data } = await axios.post(backendUrl + '/api/fragment-report/add' , {totalGram , totalAmount , toWareHouse , toPasa , detail , date})
            if (!data.success) {
                return toast.error(data.message)
            }
            if (data.success) {
                toast.success(data.message)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const convertToEnglish = (str) => {
        const map = {
            "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
            "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
            "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
            "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
        };
        return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
    };



    return (
        <div className='px-16 py-12'>
            <div>
                <h1 className='text-center mb-8 text-xl'>ثبت گزارش روزانه شکسته</h1>
                <div className='grid sm:grid-cols-2 grid-cols-1 gap-4 lg:px-32'>
                    <div className='px-8'>
                        <p>مجموع گرام</p>
                        <input onChange={(e) => setTotalGram(convertToEnglish(e.target.value))} value={totalGram} type="text" inputMode='numeric' className='px-2 w-full border border-gray-500 rounded-xs py-1' />
                    </div>

                    <div className='px-8'>
                        <p>مجموع پول</p>
                        <input onChange={(e) => setTotalAmount(convertToEnglish(e.target.value))} value={totalAmount} type="text" inputMode='numeric' className='px-2 w-full border border-gray-500 rounded-xs py-1' />
                    </div>

                    <div className='px-8'>
                        <p>به گدام</p>
                        <input onChange={(e) => setToWareHouse(convertToEnglish(e.target.value))} value={toWareHouse} type="text" inputMode='numeric' className='px-2 w-full border border-gray-500 rounded-xs py-1' />
                    </div>

                    <div className='px-8'>
                        <p>آب شده</p>
                        <input onChange={(e) => setToPasa(convertToEnglish(e.target.value))} value={toPasa} type="text" inputMode='numeric' className='px-2 w-full border border-gray-500 rounded-xs py-1' />
                    </div>

                    <div className='px-8'>
                        <p>توضیحات</p>
                        <textarea onChange={(e) => setDetail(e.target.value)} value={detail} type="text" className='px-2 w-full border border-gray-500 rounded-xs py-1' />
                    </div>

                    <div className='px-8'>
                        <p>تاریخ</p>
                        <input onChange={(e) => setDate(e.target.value)} value={date} type="date" className='px-2 w-full border border-gray-500 rounded-xs py-1' />
                    </div>
                </div>
                <div className='flex justify-center mt-8'>
                    <button onClick={handleAdd} className='bg-green-600 text-center text-white w-72 py-1 rounded-xs cursor-pointer '>ذخیره</button>
                </div>
            </div>
        </div>
    )
}

export default FragmentReport
