import React, { useContext, useEffect, useState } from 'react'
import { AppContext } from '../../context/AppContext'
import axios from 'axios'
import { toast } from 'react-toastify'
import { assets } from '../../assets/assets'

const ShowFragmentReport = () => {

    const { backendUrl } = useContext(AppContext)
    const [dailyReport, setDailyReport] = useState([])
    const [editId, setEditId] = useState("")

    const getDailyReport = async (req, res) => {
        try {
            const { data } = await axios.get(backendUrl + '/api/fragment-report/get')
            if (data.success) {
                console.log(data.daily)
                setDailyReport(data.daily)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const toPersianDate = (date) =>
        new Date(date).toLocaleDateString("fa-IR");

    useEffect(() => {
        getDailyReport()
    }, [])

    return (
        <div className='px-16 py-12'>

            <div>
                <h1 className='text-xl text-center mb-8'>گزارش شکسته هر روز</h1>
                <div>
                    <ul className='grid grid-cols-8 text-center bg-sky-700 text-white py-1'>
                        <li>شماره</li>
                        <li>گرام</li>
                        <li>پول</li>
                        <li>به گدام</li>
                        <li>آب شده</li>
                        <li>جزئیات</li>
                        <li>تاریخ</li>
                        <li>ویرایش</li>
                    </ul>
                    {dailyReport && dailyReport.map((item, index) => (
                        <ul className='grid grid-cols-8 text-center py-1 bg-gray-200'>
                            <li>{index + 1}</li>

                            {editId === item._id ? (
                                <>
                                    <input className='border border-gray-500/80' type="text" />
                                    <input className='border border-gray-500/80' type="text" />
                                    <input className='border border-gray-500/80' type="text" />
                                    <input className='border border-gray-500/80' type="text" />
                                    <input className='border border-gray-500/80' type="text" />
                                </>
                            ) : (
                                <>
                                    <li>{item.totalGram}</li>
                                    <li>{item.totalAmount}</li>
                                    <li>{item.toWareHouse}</li>
                                    <li>{item.toPasa}</li>
                                    <li>{item.detail}</li>
                                </>
                            )}

                            <li>{toPersianDate(item.date)}</li>
                            {}
                            <div><img onClick={()=>setEditId(item._id)} src={assets.edit_icon} className='w-6 cursor-pointer' alt="" /></div>
                        </ul>
                    ))}
                </div>
            </div>
        </div>
    )
}

export default ShowFragmentReport
