import React, { useContext, useEffect, useState } from 'react'
import { assets } from '../../assets/assets'
import { AppContext } from '../../context/AppContext'
import axios from 'axios'
import { toast } from 'react-toastify'

const Loan = () => {

  const { backendUrl } = useContext(AppContext)
  const [search, setSearch] = useState("")
  const [customer, setCustomer] = useState([])
  const [showDropDown, setShowDropDown] = useState(false)
  const [cId, setCId] = useState("")
  const [amount , setAmount] = useState("")
  const [currency , setCurrency] = useState("")
  const [detail , setDetail] = useState("")
  const [date , setDate] = useState(null)


  const addLoan = async(req , res)=>{
    try {
      const {data} =await axios.post(backendUrl+'/api/loan-report/add' , {amount:Number(amount) , currency , detail , date} , {params:{cId:cId}})
      if(data.success){
        toast.success(data.message)
      }
    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }

  const handleSearch = async (req, res) => {
    try {
      const { data } = await axios.get(backendUrl + `/api/customer/search-customer`, { params: { q: search } })
      return data;
    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }


  useEffect(() => {
    if (!search.trim()) {
      setCustomer([])
      return
    }

    const delay = setTimeout(async () => {

      try {
        const data = await handleSearch()
        if (data.success) {
          setCustomer(data.result)
          console.log("the founded ", data)
        }
      } catch (error) {
        console.log(error)
      }
    }, 300)

    return () => clearTimeout(delay);

  }, [search])

  const convertToEnglish = (str) => {
    const map = {
      "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
      "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
      "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
      "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
    };
    return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
  };


  return (
    <div className='px-16 py-12'>
      <div className='flex justify-center relative'>
        <input onChange={(e) => {
          setSearch(e.target.value)
          setShowDropDown(true)
        }} value={search} type="text" placeholder='جستجوی مشتری' className='border border-gray-500 py-1 px-2 w-72 rounded-xs' />
        {customer && showDropDown && customer.map((item, index) => (
          <ul onClick={() => {
            setSearch(item.customerName)
            setCId(item._id)
            setCustomer([])
            setShowDropDown(false)
          }} key={item._id} className='absolute top-12 bg-white w-72'>
            <li className='p-2 cursor-pointer hover:bg-gray-200'>{item.customerName}</li>
          </ul>
        ))}
      </div>
      <div className='flex flex-wrap justify-center gap-4 sm:px-32 mt-8' >

        <div className='px-4'>
          <p>مقدار رسید</p>
          <input onChange={(e)=>setAmount(convertToEnglish(e.target.value))} value={amount} className='w-72 border border-gray-500 py-1 px-2 rounded-xs' type="text" inputMode='numeric' />
        </div>

        <div className='px-4'>
          <p>واحد پولی</p>
          <select onChange={(e)=>setCurrency(e.target.value)} value={currency} className='w-72 border border-gray-500 py-0.5 px-2 rounded-xs' name="" id="">
            <option value="">انتخاب کنید</option>
            <option value="دالر">دالر</option>
            <option value="افغانی">افغانی</option>
          </select>
        </div>

        <div className='px-4'>
          <p>جزئیات</p>
          <textarea onChange={(e)=>setDetail(e.target.value)} value={detail} className='w-72 border border-gray-500 py-1 px-2 rounded-xs' type="text" />
        </div>

        <div className='px-4'>
          <p>تاریخ</p>
          <input onChange={(e)=>setDate(e.target.value)} value={date} className='w-72 border border-gray-500 py-1 px-2 rounded-xs' type="date" />
        </div>

      </div>

      <div className='flex justify-center mt-8'>
        <button onClick={addLoan} className='bg-green-600 text-white w-72 py-1 cursor-pointer rounded-xs'>ذخیره</button>
      </div>
    </div>
  )
}

export default Loan
