import React, { useContext, useEffect, useState } from 'react'
import { AppContext } from '../../context/AppContext'
import { toast } from 'react-toastify'
import axios from 'axios'

const ReportList = () => {

    const { backendUrl } = useContext(AppContext)
    const [report ,setReport] = useState([])


    const getLoanReport = async (req, res) => {
        try {
            const { data } = await axios.get(backendUrl + '/api/loan-report/get')
            if (data.success) {
                console.log(data)
                setReport(data.report)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(()=>{
        getLoanReport()
    },[])

    const toPersianDate = (date) =>
    new Date(date).toLocaleDateString("fa-IR");

    return (
        <div className='px-16 py-12'>
            <div>
                <ul className='grid grid-cols-[1fr_2fr_2fr_2fr_4fr_2fr] text-center bg-sky-700 text-white py-1'>
                    <li>شماره</li>
                    <li>نام قرضدار</li>
                    <li>مقدار رسید</li>
                    <li>واحد پولی</li>
                    <li>توضیحات</li>
                    <li>تاریخ</li>
                </ul>
                {report && report.map((item , index)=>(
                    <ul className='grid grid-cols-[1fr_2fr_2fr_2fr_4fr_2fr] text-center bg-gray-200 py-1'>
                        <li>{index+1}</li>
                        <li>{item.cName}</li>
                        <li>{item.amount}</li>
                        <li>{item.currency}</li>
                        <li>{item.detail}</li>
                        <li>{toPersianDate(item.date)}</li>
                    </ul>
                ))}
            </div>
        </div>
    )
}

export default ReportList
