import React from 'react'
import { useContext } from 'react'
import { AppContext } from '../../context/AppContext'
import { useState } from 'react'
import { toast } from 'react-toastify'
import axios from 'axios'

const Person = () => {

    const { backendUrl } = useContext(AppContext)
    const [name, setName] = useState("")
    const [phone, setPhone] = useState("")
    const [showDropDown , setShowDropDown] = useState(false)

    const handleAdd = async () => {
        try {
            const { data } = await axios.post(backendUrl + '/api/person/add', { name, phone })
            if (data.success) {
                toast.success(data.message)
                setName("")
                setPhone("")
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }

    }

    
    return (
        <div className='px-16 py-12'>

            <div className='flex flex-col items-center gap-4'>
                <h1 className='bg-sky-700 text-white w-72 px-2 py-1 text-center mb-4'>اضافه نمودن برداشت کننده</h1>
                <div>
                    <p>نام</p>
                    <input onChange={(e) => setName(e.target.value)} value={name} type="text" className='border border-gray-500/80 py-1 px-2 w-72 rounded-xs' />
                </div>

                <div>
                    <p>شماره تماس</p>
                    <input onChange={(e) => setPhone(e.target.value)} value={phone} type="text" className='border border-gray-500/80 py-1 px-2 w-72 rounded-xs' />
                </div>
                <button onClick={handleAdd} className='bg-green-600 text-white px-2 py-1 cursor-pointer w-72'>ذخیره</button>
            </div>
        </div>
    )
}

export default Person
