import React from 'react'
import { assets } from '../../assets/assets'
import { useState } from 'react'
import { useNavigate } from 'react-router-dom'
import { useContext } from 'react'
import { AppContext } from '../../context/AppContext'
import { useEffect } from 'react'
import { toast } from 'react-toastify'
import axios from 'axios'

const PersonExpense = () => {

    const { backendUrl } = useContext(AppContext)
    const [isToggle, setIsToggle] = useState(false)
    const [search, setSearch] = useState("")
    const [person, setPerson] = useState([])
    const [showDropDown, setShowDropDown] = useState(false)
    const [personId, setPersonId] = useState('')
    const [amount, setAmount] = useState("")
    const [currency, setCurrency] = useState("")
    const [detail, setDetail] = useState("")

    const handleSearch = async () => {
        try {
            const { data } = await axios.get(backendUrl + `/api/person/search?search=${search}`)
            return data
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(() => {
        if (!search.trim()) {
            setPerson([])
            return;
        }
        const delay = setTimeout(async () => {
            try {
                const data = await handleSearch();
                if (data.success) {
                    console.log(data)
                    setPerson(data.person || []);
                }
            } catch (error) {
                console.log(error);
            }
        }, 300);

        return () => clearTimeout(delay);
    }, [search])

    const handleAdd = async (e) => {
        e.preventDefault()

        try {
            const { data } = await axios.post(backendUrl + '/api/personal-expense/add', { amount: Number(amount), currency, detail }, { params: { personId: personId } })
            if (data.success) {
                toast.success(data.message)
            }
            if(!data.success){
                toast.warn(data.message)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)

        }
    }

    const convertToEnglish = (str) => {
        const map = {
            "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
            "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
            "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
            "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
        };
        return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
    };


    const navigate = useNavigate()
    return (
        <div className='py-8 px-16 relative'>

            <div>
                <img src={assets.drop_down_icon} className='w-8 cursor-pointer' onClick={() => setIsToggle(!isToggle)} alt="" />
                <div className={`bg-sky-700 w-56 absolute top-18 right-20 p-2 rounded-xs ${isToggle ? 'block' : 'hidden'} `}>
                    <p onClick={() => navigate('/person')} className='p-2 text-white cursor-pointer hover:bg-sky-900'>افزودن برداشت کننده</p>
                    <p onClick={()=>navigate('/show-expense')} className='p-2 text-white cursor-pointer hover:bg-sky-900'>نمایش مصارف</p>
                    <p onClick={()=>navigate('/show-person')} className='p-2 text-white cursor-pointer hover:bg-sky-900'>نمایش برداشت کننده گان </p>
                </div>
            </div>

            {/* search */}
            <div className='flex justify-center'>
                <input onChange={(e) => {
                    setSearch(e.target.value)
                    setShowDropDown(true)
                }} value={search} type="text" className='w-72 py-1 border border-gray-500/80 rounded-xs px-2 ' placeholder='جستجو نمایید' />

                {showDropDown && person && person.map((item, index) => (
                    <ul key={item._id} onClick={() => {
                        setSearch(item.name)
                        setPersonId(item._id)
                        setShowDropDown(false)
                    }} className={`bg-white w-72 rounded-xs‍‍ absolute top-26 cursor-pointer`}>
                        <li className='py-2 px-2'>{item.name}</li>
                    </ul>
                ))}
            </div>

            {/* form */}
            <div className='mt-8 flex flex-col items-center '>
                <form  >
                    <h1 className='text-center bg-sky-600 text-white w-72 mb-4 px-2'>جزئیات برداشت</h1>
                    <div className='flex flex-col justify-center items-center gap-4 '>
                        <div>
                            <p>مبلغ</p>
                            <input onChange={(e) => setAmount(convertToEnglish(e.target.value))} value={amount} className='border border-gray-500/80 rounded-xs w-72 py-1 px-2 ' type="text" inputMode='numeric' />
                        </div>

                        <div>
                            <p>واحد پولی</p>
                            <select onChange={(e) => setCurrency(e.target.value)} value={currency} className='border border-gray-500/80 rounded-xs w-72 py-1 px-2 ' name="" id="">
                                <option value="">انتخاب کنید</option>
                                <option value="افغانی">افغانی</option>
                                <option value="دالر">دالر</option>
                            </select>
                        </div>

                        <div>
                            <p>توضیحات</p>
                            <textarea onChange={(e) => setDetail(e.target.value)} value={detail} className='border border-gray-500/80 rounded-xs w-72 py-1 px-2 ' type="text" />
                        </div>

                    </div>
                    <button onClick={handleAdd} className='bg-green-600 text-white px-2 w-72 py-1 rounded-xs mt-2 cursor-pointer '>ذخیره</button>
                </form>
            </div>
        </div>
    )
}

export default PersonExpense
