import React from 'react'
import { useContext } from 'react'
import { AppContext } from '../../context/AppContext'
import { useState } from 'react'
import { useEffect } from 'react'
import { toast } from 'react-toastify'
import axios from 'axios'
import { assets } from '../../assets/assets'

const ShowExpense = () => {

    const { backendUrl } = useContext(AppContext)
    const [expense, setExpense] = useState([])
    const [showBalance, setShowBalance] = useState(false)
    const [balance, setBalance] = useState([])


    const getExpense = async (req, res) => {
        try {
            const { data } = await axios.get(backendUrl + '/api/personal-expense/get')
            if (data.success) {
                setExpense(data.expense)

            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(() => {
        getExpense()
    }, [])

    const toPersianDate = (date) =>
        new Date(date).toLocaleDateString("fa-IR");


    return (
        <div className='px-16 py-12'>
            <div>
                <ul className='grid grid-cols-5 text-center bg-sky-700 text-white py-1'>
                    <li>شماره</li>
                    <li>نام</li>
                    <li>مبلغ</li>
                    <li>واحد پولی</li>
                    <li>تاریخ</li>
                </ul>
            </div>
            {
                expense && expense.map((item, index) => (
                    <ul key={item._id} className='grid grid-cols-5 text-center'>
                        <li>{index + 1}</li>
                        <li onClick={() => handleBalance(item.personId)}>{item.name}</li>
                        <li>{item.amount}</li>
                        <li>{item.currency}</li>
                        <li>{toPersianDate(item.createdAt)}</li>
                    </ul>
                ))
            }

            
        </div>
    )
}

export default ShowExpense
