import React from 'react'
import { useContext } from 'react'
import { AppContext } from '../../context/AppContext'
import { useEffect } from 'react'
import { toast } from 'react-toastify'
import axios from 'axios'
import { useState } from 'react'
import { assets } from '../../assets/assets'

const ShowPerson = () => {

    const { backendUrl } = useContext(AppContext)
    const [person, setPerson] = useState([])
    const [showBalance, setShowBalance] = useState(false)
    const [balance, setBalance] = useState([])
    const [total, setTotal] = useState([])
    const [isToggle, setIsToggle] = useState(false)


    const getPerson = async (req, res) => {
        try {
            const { data } = await axios.get(backendUrl + '/api/person/get')
            if (data.success) {
                setPerson(data.person)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const handleTotal = async (personId) => {
        try {
            const { data } = await axios.get(backendUrl + '/api/personal-expense/total', { params: { id: personId } })
            if (data.success) {
                console.log(data)
                setTotal(data.total)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const handleBalance = async (personId) => {
        setShowBalance(true)
        try {
            const { data } = await axios.get(backendUrl + '/api/personal-expense/balance', { params: { id: personId } })
            if (data.success) {
                setBalance(data.balance)
                handleTotal(personId)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(() => {
        getPerson()

    }, [])

    const toPersianDate = (date) =>
        new Date(date).toLocaleDateString("fa-IR");

    return (
        <div className='py-12 px-16'>
            <div>
                <ul className='grid grid-cols-[1fr_3fr_3fr] text-center bg-sky-700 text-white py-1'>
                    <li>شماره</li>
                    <li>نام</li>
                    <li>شماره تماس</li>
                </ul>
                {person && person.map((p, index) => (
                    <ul className='grid grid-cols-[1fr_3fr_3fr] text-center py-1 bg-gray-200'>
                        <li>{index + 1}</li>
                        <li onClick={() => handleBalance(p._id)}>{p.name}</li>
                        <li>{p.phone}</li>
                    </ul>
                ))}
            </div>

            {showBalance && <div className='fixed inset-0 bg-black/50 flex justify-center items-center'>
                <div className='bg-white px-8 pt-12 pb-2 rounded w-[90%] h-[80%] overflow-y-auto relative'>
                    <div className='flex justify-between px-12 relative'>
                        <img onClick={() => setShowBalance(false)} src={assets.cancel_icon} className='w-8 cursor-pointer' alt="" />
                        <img onClick={() => setIsToggle(!isToggle)} src={assets.drop_down_icon} className='w-8 cursor-pointer' alt="" />
                        <div className={` p-8 text-white rounded-xs  bg-sky-700 absolute top-12 left-12 ${isToggle ? "block" : "hidden"}`}>
                            {total && total.map((t , i)=>(
                                <ul>
                                    <li>{t.amount} - {t._id}</li>
                                </ul>
                            ))}
                        </div>
                    </div>
                    <div className='px-12 py-4'>

                        {balance &&
                            <ul className='grid grid-cols-[1fr_2fr_2fr_2fr_2fr] text-center bg-sky-700 text-white py-1'>
                                <li>شماره</li>
                                <li>نام</li>
                                <li>مقدار</li>
                                <li>واحد</li>
                                <li>تاریخ</li>
                            </ul>}
                        {balance && balance.map((item, index) => (
                            <ul className='grid grid-cols-[1fr_2fr_2fr_2fr_2fr] text-center py-1 bg-gray-200'>
                                <li>{index + 1}</li>
                                <li>{item.name}</li>
                                <li>{item.amount}</li>
                                <li>{item.currency}</li>
                                <li>{toPersianDate(item.createdAt)}</li>
                            </ul>
                        ))}

                    </div>
                </div>
            </div>
            }
        </div>
    )
}

export default ShowPerson
