import React, { useContext, useState } from 'react'
import SupplierPrice from '../../components/supplier/SupplierPrice'
import { assets } from '../../assets/assets'
import { useSupplierCart } from '../../context/SupplierProduct'
import { useEffect } from 'react'
import { toast } from 'react-toastify'
import axios from 'axios'
import { AppContext } from '../../context/AppContext'
import { useNavigate } from 'react-router-dom'

const BuyProductFromSupplier = () => {
  const { backendUrl } = useContext(AppContext)
  const [showProduct, setShowProduct] = useState(false)
  const [bellNumber, setBellNumber] = useState("")
  const [search, setSearch] = useState("")
  const [supplier, setSupplier] = useState([])
  const [selectedSupplier, setSelectedSupplier] = useState("")
  const { supplierCart, setSupplierCart, removeFromCart } = useSupplierCart()
  const [showDropdown, setShowDropdown] = useState(false)
  const [isToggle, setIsToggle] = useState(false)
  const [detail , setDetail] = useState("")

  const handleAdd = async () => {
    try {
      if (!selectedSupplier || !bellNumber || supplierCart.length === 0) {
        toast.error("لطفاً همه فیلدها را پر کنید و محصول اضافه کنید");
        return;
      }

      const { data } = await axios.post(
        backendUrl + '/api/supplier-product/add',
        { products: supplierCart, supplierId: selectedSupplier, bellNumber , detail }
      );

      if (data.success) {
        toast.success(data.message);
        setBellNumber("");
        setSupplierCart([]); // خالی کردن کارت بعد از اضافه شدن
      }
    } catch (error) {
      console.log(error);
      toast.error(error.response?.data?.message || error.message);
    }
  }


  const convertToEnglish = (str) => {
    const map = {
      "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
      "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
      "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
      "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
    };
    return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
  };

  const fetchSupplier = async () => {
    try {

      const { data } = await axios.get(backendUrl + `/api/supplier/get?search=${search}`)
      return data

    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }

  useEffect(() => {
    if (!search.trim()) {
      setSupplier([])
      return
    }

    const delay = setTimeout(async () => {
      console.log("worked")
      try {
        const data = await fetchSupplier()
        if (data.success) {
          setSupplier(data.supplier)
          console.log("the founded supplier", data)
        }
      } catch (error) {
        console.log(error)
      }
    }, 300)

    return () => clearTimeout(delay);

  }, [search])

  const navigate = useNavigate()

  return (
    <div className='w-full px-16 py-8 relative'>
      <img src={assets.drop_down_icon} onClick={() => {
        setIsToggle(!isToggle)
      }} className='w-6 absolute top-12 right-24 cursor-pointer' alt="" />
      <div className={` bg-sky-600 text-white py-4 px-2 rounded absolute top-20 right-28 z-20 flex flex-col gap-4 ${isToggle ? 'block' : 'hidden'}`}>
        <p onClick={() => navigate('/supplier-list')} className='cursor-pointer'>بلانس تمویل کننده</p>
        <button onClick={() => navigate('/add-supplier')} className=' cursor-pointer'>افزودن تمویل کننده</button>
        <button onClick={() => navigate('/old')} className=' cursor-pointer'>افزودن حساب گذشته</button>
      </div>
      <div className='flex gap-12 pr-20  '>
        {/* supplier name */}
        <div className='flex flex-col gap-1 relative'>
          <label className='text-gray-700' htmlFor="">اسم تمویل کننده</label>
          <input onChange={(e) => {
            setSearch(e.target.value)
            setShowDropdown(true)
          }} value={search} className='border border-gray-400 rounded py-1 px-2 w-60' type="text" id='' />
          <div className=' w-full flex flex-col gap-2 absolute top-16 right-0 z-10 bg-white text-gray-700'>
            {showDropdown && supplier.length > 0 && supplier.map((item) => (
              <p
                onClick={(e) => {
                  e.preventDefault()
                  setSearch(item.name)
                  setSelectedSupplier(item._id)
                  setSupplier([])
                  setShowDropdown(false)
                }
                }
                className='border-b border-gray-300 cursor-pointer hover:bg-gray-100 p-3'>{item.name}</p>
            ))}
          </div>
        </div>

        {/* bell number */}
        <div>
          <p>نمبر بل</p>
          <input inputMode='numeric' type="text" onChange={(e) => setBellNumber(convertToEnglish(e.target.value))} value={bellNumber} className='py-1 border border-gray-500 rounded mt-1' />
        </div>

        <div>
          <p>جزئیات</p>
          <textarea type="text" onChange={(e) => setDetail(e.target.value)} value={detail} className='py-1 border border-gray-500 rounded mt-1' />
        </div>
      </div>

      {showProduct && <div className='fixed inset-0 z-100 bg-black/50 flex justify-center items-center'>
        <SupplierPrice showProduct={showProduct} setShowProduct={setShowProduct} />
      </div>}
      <div className='mt-8'>
        {supplierCart.length > 0 && <ul className='grid grid-cols-13 text-center bg-sky-700 text-white'>
          <li className='border border-white'>#</li>
          <li className='border border-white'>نام جنس</li>
          <li className='border border-white'>نوعیت جنس</li>
          <li className='border border-white'>عیار</li>
          <li className='border border-white'>وزن</li>
          <li className='border border-white'>پاسه</li>
          <li className='border border-white'>رسید پاسه</li>
          <li className='border border-white'>صرف باقی پاسه</li>
          <li className='border border-white'>وجوره</li>
          <li className='border border-white'>مجموع وجوره</li>
          <li className='border border-white'>رسید وجوره</li>
          <li className='border border-white'>صرق باقی وجوره</li>
          <li>#</li>
        </ul>}
        {supplierCart.length > 0 && supplierCart.map((item, index) => (
          <ul key={index} className='grid grid-cols-13 text-center text-sm'>
            <li className='bg-gray-300 py-2'>{index + 1}</li>
            <li className='bg-gray-300 py-2'>{item.name}</li>
            <li className='bg-gray-300 py-2'>{item.type}</li>
            <li className='bg-gray-300 py-2'>{item.karat}</li>
            <li className='bg-gray-300 py-2'>{item.weight}</li>
            <li className='bg-gray-300 py-2'>{item.pasa}</li>
            <li className='bg-gray-300 py-2'>{item.pasaReceipt}</li>
            <li className='bg-gray-300 py-2'>{item.pasaRemaining}</li>
            <li className='bg-gray-300 py-2'>{item.wagePerGram}</li>
            <li className='bg-gray-300 py-2'>{item.totalWage}</li>
            <li className='bg-gray-300 py-2'>{item.wageReceipt}</li>
            <li className='bg-gray-300 py-2'>{item.wageRemaining}</li>
            <li className='bg-gray-300 py-2'><img src={assets.cancel_icon} onClick={() => removeFromCart(item.name, item.karat)} className='w-6 cursor-pointer' alt="" /></li>
          </ul>
        ))}
      </div>

      <div className='w-full flex items-center justify-center mt-8 gap-8'>
        <img src={assets.sell_icon} onClick={handleAdd} className='w-20 opacity-30 cursor-pointer' alt="" />
        <img src={assets.add_icon} onClick={() => setShowProduct(true)} className='w-20 opacity-30 cursor-pointer' alt="" />
      </div>
    </div>
  )
}

export default BuyProductFromSupplier
