import React, { useContext, useState } from 'react'
import { AppContext } from '../../context/AppContext'
import { useEffect } from 'react'
import axios from 'axios'
import { toast } from 'react-toastify'

const OldTrasansaction = () => {

    const { backendUrl } = useContext(AppContext)
    const [supplierId, setSupplierId] = useState("")
    const [name, setName] = useState("")
    const [remainPasa, setRemainPasa] = useState("")
    const [remainWage, setRemainWage] = useState("")
    const [detail, setDetail] = useState("")
    const [search, setSearch] = useState("")
    const [supplier, setSupplier] = useState([])
    const [showDropDown, setShowDropDown] = useState(false)


    const handleAdd = async (req, res) => {
        try {
            const { data } = await axios.post(backendUrl + '/api/supplier-product/add-old', {name, remainPasa: Number(remainPasa), remainWage: Number(remainWage), detail } , {params:{supplierId:supplierId}})
            if (!data.success) {
                toast.error(data.message)
            }
            if (data.success) {
                toast.success(data.message)
                setName("")
                setRemainPasa("")
                setRemainWage("")
                setDetail("")
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const fetchSupplier = async () => {
        try {

            const { data } = await axios.get(backendUrl + `/api/supplier/get?search=${search}`)
            return data

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(() => {
        if (!search.trim()) {
            setSupplier([])
            return
        }

        const delay = setTimeout(async () => {
            console.log("worked")
            try {
                const data = await fetchSupplier()
                if (data.success) {
                    setSupplier(data.supplier)
                    console.log("the founded supplier", data)
                }
            } catch (error) {
                console.log(error)
            }
        }, 300)

        return () => clearTimeout(delay);

    }, [search])

    const convertToEnglish = (str) => {
        const map = {
            "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
            "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
            "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
            "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
        };
        return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
    };

    return (
        <div className='py-12 px-16'>
            <div>
                <h1 className='text-center text-2xl mb-8'>ثبت حساب گذشته</h1>
                <div>
                    <div className='flex justify-center relative'>
                        <input onChange={(e) => {
                            setSearch(e.target.value)
                            setShowDropDown(true)
                        }} value={search} type="text" placeholder='جستجوی تمویل کننده' className='w-72 py-1 px-2 border border-gray-500/50 rounded-xs' />

                        <div className=' w-full flex flex-col gap-2 absolute top-16 right-0 z-10 bg-white text-gray-700'>
                        {showDropDown && supplier.length > 0 && supplier.map((item, index) => (
                            <ul
                                onClick={(e) => {
                                    e.preventDefault()
                                    setSearch(item.name)
                                    setSupplierId(item._id)
                                    setSupplier([])
                                    setShowDropDown(false)
                                }}
                                className='border-b border-gray-300 cursor-pointer hover:bg-gray-100 p-3 w-full'>
                                <li>{item.name}</li>
                                <li>{item.phone}</li>
                            </ul>
                        ))}
                    </div>

                    </div>

                    
                    <div className='grid grid-cols-3 gap-4 mt-8'>
                        <div className='mx-4'>
                            <p>نام جنس</p>
                            <input onChange={(e) => setName(e.target.value)} value={name} type="text" className='border border-gray-500/50 w-full py-1 px-2 rounded-xs ' />
                        </div>

                        <div className='mx-4'>
                            <p>باقی پاسه</p>
                            <input onChange={(e) => setRemainPasa(convertToEnglish(e.target.value))} value={remainPasa} type="text" className='border border-gray-500/50 w-full py-1 px-2 rounded-xs ' />
                        </div>

                        <div className='mx-4'>
                            <p>باقی وجوره</p>
                            <input onChange={(e) => setRemainWage(convertToEnglish(e.target.value))} value={remainWage} type="text" className='border border-gray-500/50 w-full py-1 px-2 rounded-xs ' />
                        </div>

                        <div className='mx-4'>
                            <p>توضیحات</p>
                            <textarea onChange={(e) => setDetail(e.target.value)} value={detail} type="text" className='border border-gray-500/50 w-full py-1 px-2 rounded-xs ' name="" id=""></textarea>
                        </div>

                    </div>

                    <div className='flex justify-center mt-2'>
                        <button onClick={handleAdd} className='bg-green-600 text-center text-white w-80 py-1 rounded-xs cursor-pointer'>ذخیره</button>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default OldTrasansaction
