import React, { useContext, useEffect, useState } from 'react'
import { assets } from '../../assets/assets';
import DatePicker from "react-multi-date-picker";
import persian from "react-date-object/calendars/persian";
import persian_fa from "react-date-object/locales/persian_fa";
import axios from 'axios';
import { toast } from 'react-toastify';
import { AppContext } from '../../context/AppContext';
import { useNavigate } from 'react-router-dom';


const RegisterSupplierProduct = () => {

    const { backendUrl } = useContext(AppContext)
    const [isAddTOggleOn, setIsAddToggleOn] = useState(false)
    const [isRemoveToggleOn, setIsRemoveToggleOn] = useState(false)
    const [selected, setSelected] = useState("");
    const [newOption, setNewOption] = useState("")
    const [isEdit, setIsEdit] = useState(false)
    const [search, setSearch] = useState("")
    const [image, setImage] = useState(null)
    const [barcode, setBarcode] = useState("")
    const [supplierProduct, setSupplierProduct] = useState([])
    const [selectedProduct, setSelectedProduct] = useState([])
    const [isTogggle, setIsToggle] = useState(false)
    const [gram, setgram] = useState("")
    const [auns, setAuns] = useState("")
    const [wage, setWage] = useState("")
    const [showDropdown, setShowDropdown] = useState(false)

    console.log(selectedProduct)


    const handleSearch = async () => {
        try {
            const { data } = await axios.get(backendUrl + `/api/supplier-product/search?search=${search}`)
            return data
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }

    }

    useEffect(() => {
        if (!search.trim()) {
            setSupplierProduct([])
            return
        }

        const delay = setTimeout(async () => {

            try {

                const data = await handleSearch()
                if (data.success) {
                    console.log(data)
                    setSupplierProduct(data.product || 0)
                }

            } catch (error) {
                console.log(error)
            }

        }, 300)

        return () => clearTimeout(delay)
    }, [search])


    const updateQuantity = async (e) => {

        e.preventDefault()

        try {
            const { data } = await axios.put(backendUrl + '/api/supplier-product/update', {
                bellNumber: selectedProduct.bellNumber,
                productId: selectedProduct.products._id,
                gram
            })

            if (data.success) {
                toast.success(data.message)
                handleSubmit()
            }
            if(!data.success){
                return toast.error(data.message)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const handleSubmit = async () => {

        event.preventDefault()

        try {

            const formData = new FormData()
            formData.append('productName', selectedProduct.products.name);
            formData.append('type', selectedProduct.products.type);
            formData.append('gram', Number(gram));
            formData.append('karat', Number(selectedProduct.products.karat));
            formData.append('bellNumber', Number(selectedProduct.bellNumber));
            formData.append('wage', Number(wage));
            formData.append('auns', Number(auns));
            if (image) { formData.append('image', image); }

            const { data } = await axios.post(backendUrl + '/api/product/new-product', formData)

            if (data.success) {
                toast.success(data.message)
                setSearch("")
                setSelectedProduct([])
            } else {
                toast.error(data.message)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const convertToEnglish = (str) => {
    const map = {
      "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
      "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
      "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
      "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
    };
    return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
  };

    const navigate = useNavigate()


    return (
        <div className='flex-1 py-8 px-16 relative'>
            <img src={assets.drop_down_icon} onClick={() => setIsToggle(!isTogggle)} className='w-6 absolute top-12 right-20 cursor-pointer' alt="" />
            <div className={`flex flex-col bg-sky-700 absolute top-20 right-24 py-6 px-4 gap-4 rounded ${isTogggle ? 'block' : "hidden"} `}>
                <button onClick={() => navigate('/daily')} className=' text-gray-100  py-1 rounded cursor-pointer text-sm text-start'>اجناس ثبت شده اخیر</button>
                <button onClick={() => navigate('/remain')} className=' text-gray-100  py-1 rounded cursor-pointer text-sm text-start'>اجناس ثبت نا شده</button>
            </div>
            <form onSubmit={updateQuantity} action="">
                <div className='flex justify-center pb-12 font-bold text-3xl '>
                    <h1>ثبت اجناس جدید</h1>
                </div>
                <div>
                    {/* ---- Register new product ---- */}

                    <div className='w-full flex justify-center'>
                        <div action="" >
                            <div className='grid grid-cols-[1fr] gap-x-12 gap-y-4 relative'>
                                <div className='grid grid-cols-2 gap-8'>
                                    <div className=''>
                                        <p className='pb-1 text-gray-700'>نام جنس</p>
                                        <input className='border border-gray-300 rounded h-8 w-72' type="text" onChange={(e) => {
                                            
                                            setSearch(e.target.value)
                                            setShowDropdown(true)
                                            }} value={search} />
                                    </div>

                                    <div className=''>
                                        <p className='pb-1 text-gray-700'>گرام</p>
                                        <input className='border border-gray-300 rounded h-8 w-72' type="text" inputMode='numeric' onChange={(e) => setgram(convertToEnglish(e.target.value))} value={gram} />
                                    </div>

                                    <div className=''>
                                        <p className='pb-1 text-gray-700'>وجوره</p>
                                        <input className='border border-gray-300 rounded h-8 w-72' type="text" inputMode='numeric' onChange={(e) => setWage(convertToEnglish(e.target.value))} value={wage} />
                                    </div>

                                    <div className=''>
                                        <p className='pb-1 text-gray-700'>انس</p>
                                        <input className='border border-gray-300 rounded h-8 w-72' type="text" inputMode='numeric' onChange={(e) => setAuns(convertToEnglish(e.target.value))} value={auns} />
                                    </div>
                                </div>
                                <div className='absolute top-16 w-full z-20'>
                                    <div className='bg-white w-full rounded '>{showDropdown && supplierProduct
                                        ?.filter(item => !item.products.isCompleted)
                                        .map((item, index) => (
                                            <div
                                                key={index}
                                                onClick={() => {
                                                    setSelectedProduct(item)
                                                    setSearch(item.products.name)
                                                    setSupplierProduct([])
                                                    setShowDropdown(false)
                                                }}
                                                className='p-3 hover:bg-gray-200 cursor-pointer'
                                            >
                                                <div className='flex justify-between'>
                                                    <p>
                                                        <span className='font-medium text-lg'>{item.products.name}</span> -{" "}
                                                        <span className='text-gray-700'>{item.products.type}</span>
                                                    </p>
                                                    <p className='text-xs text-gray-500'>
                                                        نام تمویل کننده : {item.supplierName}
                                                    </p>
                                                </div>

                                                <div className='flex justify-between text-xs'>
                                                    <p className='flex gap-4 text-gray-700'>
                                                        <span>{item.products.karat} - عیار</span>
                                                    </p>
                                                    <p className='flex gap-4 text-gray-500'>
                                                        گرام ثبت نا شده : {item.products.remainWeight}
                                                    </p>
                                                </div>
                                            </div>
                                        ))
                                    }
                                    </div>
                                </div>

                            </div>
                            <div className='flex justify-center gap-4 mt-6 '>
                                <button type='reset' className='border border-gray-200 rounded-md py-0.5 px-2 cursor-pointer bg-gray-200 w-28 '>ریسیت</button>
                                <button type='submit' className='border border-gray-100 rounded-md py-0.5 px-4 cursor-pointer bg-green-600 text-gray-200 w-28 '>ثبت</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div className='flex gap-x-12 justify-center mt-8 pr-8'>
                    <div className='flex flex-col items-center justify-center '>
                        <div className='flex justify-center'>
                            <label htmlFor="image">
                                <div className='inline-block relative cursor-pointer'>
                                    <img className='w-40 rounded-full opacity-60 ' src={image ? URL.createObjectURL(image) : ``} alt="" />
                                    <img className='w-16 absolute top-12 right-12 opacity-50' src={image ? '' : assets.upload_icon} alt="" />
                                </div>
                                <input onChange={(e) => setImage(e.target.files[0])} type="file" id="image" hidden />
                                <p className={`text-sm text-gray-500 text-center  ${image ? 'hidden' : 'block'}`}>عکس جنس را آپلود کنید</p>
                            </label>
                        </div>
                        <button onClick={() => setImage(null)} className={`bg-blue-600 py-0.5 px-2 rounded text-white text-center cursor-pointer ${!image ? 'hidden' : 'block'} `} type='button'>پاک کردن عکس</button>
                    </div>

                    <div>

                    </div>
                </div>
            </form>
            {/* <button onClick={()=>navigate('/exist-product')} className='bg-sky-600 text-white w-40 py-1 rounded cursor-pointer mt-20 mr-12 text-sm '>مجموع اجناس ثبت شده</button> */}

        </div>
    )
}

export default RegisterSupplierProduct
