import React, { useContext, useEffect } from 'react'
import { useState } from 'react'
import { toast } from 'react-toastify'
import axios from 'axios'
import { AppContext } from '../../context/AppContext'
import { assets } from '../../assets/assets'
import { useNavigate } from 'react-router-dom'

const ExistTrader = () => {

    const { backendUrl } = useContext(AppContext)

    const [traders, setTrader] = useState([])
    const [search, setSearch] = useState('')
    const [trade, setTrade] = useState([])
    const [showDropDown, setShowDropDown] = useState(false)
    const [show, setShow] = useState(false)
    const [personTrade, setPersonTrade] = useState(null)

    const getTraders = async (req, res) => {
        try {
            const { data } = await axios.get(backendUrl + '/api/trader/get')
            if (data.success) {
                console.log(data)
                setTrader(data.trader)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const getPersonTrade = async (traderId) => {
        setShow(true)
        try {
            const { data } = await axios.get(backendUrl + `/api/trade/person?traderId=${traderId}`)
            if (data.success) {
                console.log("data is", data)
                setPersonTrade(data.personTrade[0])
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const handleSearch = async () => {
        try {
            const data = await axios.get(backendUrl + `/api/trade/search?search=${search}`)
            return data
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(() => {
        if (!search.trim()) {
            setTrade([]);
            return;
        }
        console.log("worked")

        const delay = setTimeout(async () => {
            try {
                const { data } = await handleSearch();
                if (data.success) {
                    console.log(data)
                    setTrade(data.data || []);
                }
            } catch (error) {
                console.log(error);
            }
        }, 300);

        return () => clearTimeout(delay);
    }, [search]);

    const toPersianDate = (date) =>
        new Date(date).toLocaleDateString("fa-IR");

    useEffect(() => {
        getTraders()
    }, [])

    const navigate = useNavigate()

    return (
        <div className='w-full px-16 py-8'>

            <div className='relative flex justify-center mb-2'>
                <input onChange={(e) => {
                    setSearch(e.target.value)
                    showDropDown(true)
                }} value={search} className='border border-gray-500 w-72 py-1 px-2 rounded-xs' placeholder='جستجو' type="text" />
            </div>

            <ul className='grid grid-cols-5 text-center bg-sky-700 text-white py-1'>
                <li>#</li>
                <li>نام معامله کننده</li>
                <li>شماره تماس</li>
                <li>آدرس</li>
                <li>#</li>
            </ul>
            {(trade && trade.length > 0 ? trade : traders).map((item, index) => (
                <ul className='grid grid-cols-5 text-center'>
                    <li>{index + 1}</li>
                    <li>{item.name}</li>
                    <li>{item.phone}</li>
                    <li>{item.address}</li>
                    <li onClick={() => {
                        getPersonTrade(item._id)
                    }} className='cursor-pointer bg-sky-700 text-white border-t border-gray-200/50'>نمایش</li>
                </ul>
            ))}

            <div className={`fixed inset-0 z-100 bg-black/50 flex justify-center items-center ${show ? 'block' : 'hidden'}`}>
                <div className="bg-white px-8 pt-4 pb-4 rounded w-[90%] max-h-[80%] overflow-y-scroll relative z-50">
                    <div className='flex justify-between'>
                        <img src={assets.cancel_icon} onClick={() => setShow(false)} className='w-6 cursor-pointer' alt="" />
                        <img src={assets.add_icon} onClick={() => navigate('/new-trade')} className='w-6 cursor-pointer' alt="" />
                    </div>
                    <div className='grid grid-cols-3 gap-20 mb-20'>

                        {personTrade && personTrade.summary.map((item, index) => {
                            const credit = Number(item.totalCredit?.$numberDecimal || 0)
                            const debit = Number(item.totalDebit?.$numberDecimal || 0)
                            const balance = Number(item.balance?.$numberDecimal || 0)

                            return (
                                <div
                                    key={index}
                                    className="border border-gray-300 rounded p-4 text-center bg-gray-50"
                                >
                                    <p className="font-bold text-lg">{item.currency}</p>

                                    <p className="text-green-600">
                                        طلب: {credit.toLocaleString()}
                                    </p>

                                    <p className="text-red-600">
                                        گرفت: {debit.toLocaleString()}
                                    </p>

                                    <hr className="my-2" />

                                    <p className="font-semibold">
                                        باقی حساب: {balance.toLocaleString()}
                                    </p>
                                </div>
                            )
                        })}

                    </div>
                        {/* افغانی */}
                    <div className='border mb-20'>
                        <h1 className='text-center mb-4 text-xl bg-sky-700 text-white py-1'>حساب افغانی</h1>
                        <div className='grid grid-cols-2'>
                            {/* طلب */}
                            <div className=''>
                                <div className='border-l px-4'>
                                    <h1 className='text-lg bg-green-600 text-white py-1 text-center'>طلبات</h1>
                                    <ul className='grid grid-cols-[1fr_2fr_2fr_4fr] text-center bg-sky-700 py-1 text-white'>
                                        <li className='border-l '>شماره</li>
                                        <li className='border-l '>مقدار</li>
                                        <li className='border-l '>تاریخ</li>
                                        <li>جزئیات</li>
                                    </ul>
                                    {personTrade && personTrade.transactions.filter(i => i.currency === 'افغانی' && i.type === "طلب").map((item, index) => (
                                        <div>
                                            <ul className='grid grid-cols-[1fr_2fr_2fr_4fr] text-center border-b border-gray-500/50'>
                                                <li className='border-l border-gray-500/50 py-1'>{index + 1}</li>
                                                <li className='border-l border-gray-500/50 py-1'>{item.amount}</li>
                                                <li className='border-l border-gray-500/50 py-1'>{toPersianDate(item.createdAt)}</li>
                                                <li>{item.detail}</li>
                                            </ul>
                                        </div>
                                    ))}
                                </div>

                            </div>

                            {/* رسید */}
                            <div className=' px-4'>
                                <div >
                                    <h1 className='text-lg bg-green-600 text-white py-1 text-center'>گرفت</h1>
                                    <ul className='grid grid-cols-[1fr_2fr_2fr_4fr] text-center bg-sky-700 py-1 text-white'>
                                        <li className='border-l '>شماره</li>
                                        <li className='border-l '>مقدار</li>
                                        <li className='border-l '>تاریخ</li>
                                        <li>جزئیات</li>
                                    </ul>
                                    {personTrade && personTrade.transactions.filter(i => i.currency === 'افغانی' && i.type === "پرداخت").map((item, index) => (
                                        <div>
                                            <ul className='grid grid-cols-[1fr_2fr_2fr_4fr] text-center border-b border-gray-500/50'>
                                                <li className='border-l border-gray-500/50 py-1'>{index + 1}</li>
                                                <li className='border-l border-gray-500/50 py-1'>{item.amount}</li>
                                                <li className='border-l border-gray-500/50 py-1'>{toPersianDate(item.createdAt)}</li>
                                                <li>{item.detail}</li>
                                            </ul>
                                        </div>
                                    ))}
                                </div>

                            </div>
                        </div>

                    </div>

                        {/* دالر */}
                    <div className='border mb-20'>
                        <h1 className='text-center mb-4 text-xl bg-sky-700 text-white py-1'>حساب دالری</h1>
                        <div className='grid grid-cols-2'>
                            {/* طلب */}
                            <div className=''>
                                <div className='border-l px-4'>
                                    <h1 className='text-lg bg-green-600 text-white py-1 text-center'>طلبات</h1>
                                    <ul className='grid grid-cols-[1fr_2fr_2fr_4fr] text-center bg-sky-700 py-1 text-white'>
                                        <li className='border-l '>شماره</li>
                                        <li className='border-l '>مقدار</li>
                                        <li className='border-l '>تاریخ</li>
                                        <li>جزئیات</li>
                                    </ul>
                                    {personTrade && personTrade.transactions.filter(i => i.currency === 'دالر' && i.type === "طلب").map((item, index) => (
                                        <div>
                                            <ul className='grid grid-cols-[1fr_2fr_2fr_4fr] text-center border-b border-gray-500/50'>
                                                <li className='border-l border-gray-500/50 py-1'>{index + 1}</li>
                                                <li className='border-l border-gray-500/50 py-1'>{item.amount}</li>
                                                <li className='border-l border-gray-500/50 py-1'>{toPersianDate(item.createdAt)}</li>
                                                <li>{item.detail}</li>
                                            </ul>
                                        </div>
                                    ))}
                                </div>

                            </div>

                            {/* رسید */}
                            <div className=' px-4'>
                                <div >
                                    <h1 className='text-lg bg-green-600 text-white py-1 text-center'>گرفت</h1>
                                    <ul className='grid grid-cols-[1fr_2fr_2fr_4fr] text-center bg-sky-700 py-1 text-white'>
                                        <li className='border-l '>شماره</li>
                                        <li className='border-l '>مقدار</li>
                                        <li className='border-l '>تاریخ</li>
                                        <li>جزئیات</li>
                                    </ul>
                                    {personTrade && personTrade.transactions.filter(i => i.currency === 'دالر' && i.type === "پرداخت").map((item, index) => (
                                        <div>
                                            <ul className='grid grid-cols-[1fr_2fr_2fr_4fr] text-center border-b border-gray-500/50'>
                                                <li className='border-l border-gray-500/50 py-1'>{index + 1}</li>
                                                <li className='border-l border-gray-500/50 py-1'>{item.amount}</li>
                                                <li className='border-l border-gray-500/50 py-1'>{toPersianDate(item.createdAt)}</li>
                                                <li>{item.detail}</li>
                                            </ul>
                                        </div>
                                    ))}
                                </div>

                            </div>
                        </div>

                    </div>

                    {/* حساب پاسه */}
                        <div className='border mb-8'>
                        <h1 className='text-center mb-4 text-xl bg-sky-700 text-white py-1'>حساب پاسه</h1>
                        <div className='grid grid-cols-2'>
                            {/* طلب */}
                            <div className=''>
                                <div className='border-l px-4'>
                                    <h1 className='text-lg bg-green-600 text-white py-1 text-center'>طلبات</h1>
                                    <ul className='grid grid-cols-[1fr_2fr_2fr_4fr] text-center bg-sky-700 py-1 text-white'>
                                        <li className='border-l '>شماره</li>
                                        <li className='border-l '>مقدار</li>
                                        <li className='border-l '>تاریخ</li>
                                        <li>جزئیات</li>
                                    </ul>
                                    {personTrade && personTrade.transactions.filter(i => i.currency === 'پاسه' && i.type === "طلب").map((item, index) => (
                                        <div>
                                            <ul className='grid grid-cols-[1fr_2fr_2fr_4fr] text-center border-b border-gray-500/50'>
                                                <li className='border-l border-gray-500/50 py-1'>{index + 1}</li>
                                                <li className='border-l border-gray-500/50 py-1'>{item.amount}</li>
                                                <li className='border-l border-gray-500/50 py-1'>{toPersianDate(item.createdAt)}</li>
                                                <li>{item.detail}</li>
                                            </ul>
                                        </div>
                                    ))}
                                </div>

                            </div>

                            {/* رسید */}
                            <div className=' px-4'>
                                <div >
                                    <h1 className='text-lg bg-green-600 text-white py-1 text-center'>گرفت</h1>
                                    <ul className='grid grid-cols-[1fr_2fr_2fr_4fr] text-center bg-sky-700 py-1 text-white'>
                                        <li className='border-l '>شماره</li>
                                        <li className='border-l '>مقدار</li>
                                        <li className='border-l '>تاریخ</li>
                                        <li>جزئیات</li>
                                    </ul>
                                    {personTrade && personTrade.transactions.filter(i => i.currency === 'پاسه' && i.type === "پرداخت").map((item, index) => (
                                        <div>
                                            <ul className='grid grid-cols-[1fr_2fr_2fr_4fr] text-center border-b border-gray-500/50'>
                                                <li className='border-l border-gray-500/50 py-1'>{index + 1}</li>
                                                <li className='border-l border-gray-500/50 py-1'>{item.amount}</li>
                                                <li className='border-l border-gray-500/50 py-1'>{toPersianDate(item.createdAt)}</li>
                                                <li>{item.detail}</li>
                                            </ul>
                                        </div>
                                    ))}
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    )
}

export default ExistTrader
