import axios from 'axios'
import React, { useContext } from 'react'
import { useState } from 'react'
import { AppContext } from '../../context/AppContext'
import { useEffect } from 'react'
import { assets } from '../../assets/assets'
import { useNavigate } from 'react-router-dom'
import { toast } from 'react-toastify'

const NewTrade = () => {

    const { backendUrl } = useContext(AppContext)
    const [search, setSearch] = useState("")
    const [selectedTrader, setSelectedTrader] = useState("")
    const [trade, setTrade] = useState([])
    const [isToggle, setIsToggle] = useState(false)
    const [traderId, setTraderId] = useState("")
    const [amount, setAmount] = useState("")
    const [type, setType] = useState("")
    const [detail, setDetail] = useState("")
    const [currency, setCurrency] = useState("")


    console.log("traderId is :", traderId)

    const handleAdd = async (req, res) => {
        try {
            const { data } = await axios.post(backendUrl + "/api/trade/add", { traderId, amount: Number(amount), type, detail, currency })
            if (data.success) {
                toast.success(data.message)
            }
            if(!data.success){
                return toast.warn(data.message)
            }

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const handleSearch = async () => {
        try {
            const data = await axios.get(backendUrl + `/api/trade/search?search=${search}`)
            return data
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(() => {
        if (!search.trim()) {
            setTrade([]);
            return;
        }
        console.log("worked")

        const delay = setTimeout(async () => {
            try {
                const { data } = await handleSearch();
                if (data.success) {
                    console.log(data)
                    setTrade(data.data || []);
                }
            } catch (error) {
                console.log(error);
            }
        }, 300);

        return () => clearTimeout(delay);
    }, [search]);

    const navigate = useNavigate()

    const convertToEnglish = (str) => {
        const map = {
            "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
            "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
            "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
            "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
        };
        return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
    };


    return (
        <div className='w-full py-8 px-16'>

            <img src={assets.drop_down_icon} onClick={() => setIsToggle(!isToggle)} className='w-6 cursor-pointer top-8 right-32' alt="" />
            <div className={` bg-sky-700 absolute top-16 right-36 p-4 text-white flex flex-col rounded gap-4 ${isToggle ? 'block' : "hidden"}`}>
                <p onClick={() => navigate('/trader')} className='cursor-pointer'>افزورن معامله دار</p>
                <p onClick={() => navigate('/exist-trader')} className='cursor-pointer'>نمایش معامله داران</p>
            </div>
            <div className='flex justify-center relative'>
                <div>
                    <input onChange={(e) => {
                        setSearch(e.target.value)
                        setShowDropdown(true)
                    }} value={search} className=' w-72 border border-gray-500 rounded-xs py-1 px-2' type="text" placeholder='جستجوی معامله دار' />
                </div>
                <div className='absolute top-12 bg-white w-72'>
                    {trade && trade.map((item, index) => (
                        <ul onClick={() => {
                            setSearch(item.name)
                            setTraderId(item._id)
                            setTrade([])
                            setShowDropdown(false)
                        }} className='cursor-pointer p-2' key={item._id}>
                            <li>{item.name}</li>
                            <li>{item.phone}</li>
                        </ul>
                    ))}
                </div>
            </div>

            <div className='flex flex-wrap justify-center text-center gap-12 lg:px-32 mt-12'>
                {/* amount */}
                <div className="flex flex-col items-center justify-center">
                    <p>مبلغ</p>
                    <input onChange={(e) => setAmount(convertToEnglish(e.target.value))} value={amount} className='border border-gray-500 w-72 py-1 rounded-xs' type="text" inputMode='numeric' />
                </div>

                {/* type */}
                <div className="flex flex-col items-center">
                    <p>نوعیت</p>
                    <select onChange={(e) => setType(e.target.value)} value={type} className='border border-gray-500 w-72 py-0.5 rounded-xs' name="" id="">
                        <option value="">انتخاب کنید</option>
                        <option value="طلب">طلب</option>
                        <option value="پرداخت">پرداخت</option>
                    </select>
                </div>

                {/* deatil */}
                <div className="flex flex-col items-center">
                    <p>توضیحات</p>
                    <textarea onChange={(e) => setDetail(e.target.value)} value={detail} className='border border-gray-500 w-72 py-1 rounded-xs' type="text" />
                </div>

                {/* currency */}
                <div className="flex flex-col items-center">
                    <p>واحد</p>
                    <select onChange={(e) => setCurrency(e.target.value)} value={currency} className='border border-gray-500 w-72 py-0.5 rounded-xs' name="" id="">
                        <option value="">واحد</option>
                        <option value="دالر">دالر</option>
                        <option value="افغانی">افغانی</option>
                        <option value="پاسه">پاسه</option>
                    </select>
                </div>

                <button onClick={handleAdd} className='w-80 bg-green-600 text-center text-white py-0.5 rounded-xs cursor-pointer'>ذخیره</button>
            </div>
        </div>
    )
}

export default NewTrade
