import React, { useContext, useState } from 'react'
import { AppContext } from '../../context/AppContext'
import axios from 'axios'
import { toast } from 'react-toastify'
import { useNavigate } from 'react-router-dom'


const Trader = () => {

    const { backendUrl } = useContext(AppContext)
    const [name , setName]= useState("")
    const [phone , setPhone]= useState("")
    const [address , setAddress]= useState("")
    const [traders, setTrader] = useState([])

    const getTraders = async (req, res) => {
        try {
            const { data } = await axios.get(backendUrl + '/api/trader/get')
            if (data.success) {
                console.log(data)
                setTrader(data.trader)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const addTrader = async()=>{
        try {

            const {data} = await axios.post(backendUrl+'/api/trader/add',{name , phone , address})
            if(data.success){
                toast.success(data.message)
            }
            
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const navigate = useNavigate()

    return (
        <div className='flex flex-col items-center pt-12 gap-4'>

            <div>
                <p className='mb-2'>نام معامله دار</p>
                <input onChange={(e)=>setName(e.target.value)} value={name}  className='border border-gray-500 rounded-xs py-1 w-72' type="text" />
            </div>

            <div>
                <p className='mb-2'>شماره تماس</p>
                <input onChange={(e)=>setPhone(e.target.value)} value={phone} className='border border-gray-500 rounded-xs py-1 w-72' type="text" />
            </div>

            <div>
                <p className='mb-2'>آدرس</p>
                <input onChange={(e)=>setAddress(e.target.value)} value={address} className='border border-gray-500 rounded-xs py-1 w-72' type="text" />
            </div>

            <p onClick={()=>navigate('/exist-trader')}  className='text-green-600 text-xs cursor-pointer underline'>معامله داران ثبت شده</p>

            <button onClick={addTrader} className='w-72 bg-green-600 rounded-xs py-1 text-white cursor-pointer'>ذخیره</button>

        </div>
    )
}

export default Trader
